/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.system;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.XMLEncodeable;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.util.PAPublication;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import java.net.InetAddress;
import org.w3c.dom.Node;

public class RemoteConsoleSystem
extends RemoteSystem
implements RemoteEntity {
    private static final String TRACE_MASKT = "XPARCSYT";
    private static final String TRACE_MASKF = "XPARCSYF";
    private static final String TRACE_MASKD = "XPARCSYD";
    public RemoteConsoleSystemPersistentData rcsPD = null;
    private transient RemoteEntity remEntity = null;

    public RemoteConsoleSystem() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.initPersistentData();
    }

    public RemoteConsoleSystem(RemoteEntity remEntity) {
        this();
        this.remEntity = remEntity;
        this.setMachineType(PASystem.extractMachineType(remEntity.getMTMS()));
        this.setMachineModel(PASystem.extractMachineModel(remEntity.getMTMS()));
        this.setMachineSerial(PASystem.extractMachineSerial(remEntity.getMTMS()));
        this.setSystemName(this.getMTMS());
        InetAddress[] ipas = this.getNicAddresses();
        if (ipas != null) {
            for (int i = 0; i < ipas.length; ++i) {
                this.addIPAddr(ipas[i].getHostAddress());
            }
        }
    }

    public RemoteConsoleSystem(PersistentData data) throws PersistenceException {
        super(((RemoteConsoleSystemPersistentData)data).superData);
        this.initPersistentData();
    }

    private void initPersistentData() {
        this.rcsPD = new RemoteConsoleSystemPersistentData();
        this.rcsPD.superData = super.getPersistentData();
    }

    public PersistentData getPersistentData() {
        if (this.rcsPD.superData == null) {
            this.rcsPD.superData = super.getPersistentData();
        }
        return this.rcsPD;
    }

    public String getRESystemName() {
        if (this.remEntity != null) {
            return ((Object)this.remEntity).toString();
        }
        return "";
    }

    public void publish(Message msg) throws HException {
        if (!this.canConnect()) {
            if (PAPublication.isPublicationEnabled()) {
                throw new HException("No RemoteEntity reference");
            }
            throw new HException("PA Publication disabled");
        }
        this.remEntity.publish(msg);
    }

    public boolean canConnect() {
        return this.remEntity != null && PAPublication.isPublicationEnabled();
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteConsoleSystem) {
            RemoteConsoleSystem oRCS = (RemoteConsoleSystem)o;
            if (this.getMTMS().equals("0-0/0") || oRCS.getMTMS().equals("0-0/0")) {
                return this.getRESystemName().equals(oRCS.getRESystemName());
            }
            return this.getMTMS().equals(oRCS.getMTMS());
        }
        if (o instanceof PASystem) {
            PASystem oPAS = (PASystem)o;
            if (this.getMTMS().equals("0-0/0")) {
                return false;
            }
            return this.getMTMS().equals(oPAS.getMTMS());
        }
        return false;
    }

    public String toString() {
        return this.getSystemName() + "," + this.getRESystemName();
    }

    public InetAddress[] getNicAddresses() {
        return this.remEntity.getNicAddresses();
    }

    public static class RemoteConsoleSystemPersistentData
    implements PersistentData,
    XMLEncodeable {
        private static final long serialVersionUID = -6967681558426484492L;
        public PersistentData superData = null;

        public void toXML(StringBuffer sb) {
        }

        public void fromXML(Node node) {
        }
    }
}

